/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;

public final class LuceneInstantFieldCodec
extends AbstractLuceneNumericFieldCodec<Instant, Long> {
    static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

    public LuceneInstantFieldCodec(boolean projectable, boolean sortable, Instant indexNullAsValue) {
        super(projectable, sortable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Instant value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public Instant decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return FORMATTER.parse((CharSequence)value, Instant::from);
    }

    @Override
    public Long encode(Instant value) {
        return value == null ? null : Long.valueOf(value.toEpochMilli());
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }
}

