/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneBigIntegerFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneBigIntegerIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneBigIntegerIndexFieldTypeContext, BigInteger>
implements ScaledNumberIndexFieldTypeContext<LuceneBigIntegerIndexFieldTypeContext, BigInteger> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Sortable sortable = Sortable.DEFAULT;
    private Integer decimalScale = null;

    LuceneBigIntegerIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigInteger.class);
        this.defaultsProvider = defaultsProvider;
    }

    public LuceneBigIntegerIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    public LuceneBigIntegerIndexFieldTypeContext decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this;
    }

    @Override
    public LuceneIndexFieldType<BigInteger> toIndexFieldType() {
        boolean resolvedSortable = LuceneBigIntegerIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneBigIntegerIndexFieldTypeContext.resolveDefault(this.projectable);
        int resolvedDecimalScale = this.resolveDecimalScale();
        if (resolvedDecimalScale > 0) {
            throw log.invalidDecimalScale(resolvedDecimalScale, this.getBuildContext().getEventContext());
        }
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneBigIntegerFieldCodec codec = new LuceneBigIntegerFieldCodec(resolvedProjectable, resolvedSortable, (BigInteger)this.indexNullAsValue, resolvedDecimalScale);
        return new LuceneIndexFieldType<BigInteger>(codec, new LuceneNumericFieldPredicateBuilderFactory<BigInteger, Long>((ToDocumentFieldValueConverter<?, BigInteger>)dslToIndexConverter, (ToDocumentFieldValueConverter<BigInteger, BigInteger>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<BigInteger, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, BigInteger>)dslToIndexConverter, (ToDocumentFieldValueConverter<BigInteger, BigInteger>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<BigInteger>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneBigIntegerIndexFieldTypeContext thisAsS() {
        return this;
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.getDecimalScale() != null) {
            return this.defaultsProvider.getDecimalScale();
        }
        throw log.nullDecimalScale(this.getBuildContext().getEventContext());
    }
}

