/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneGeoPointFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneGeoPointFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneGeoPointFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneGeoPointFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.spatial.GeoPoint;

class LuceneGeoPointIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneGeoPointIndexFieldTypeContext, GeoPoint> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneGeoPointIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, GeoPoint.class);
    }

    public LuceneGeoPointIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<GeoPoint> toIndexFieldType() {
        boolean resolvedSortable = LuceneGeoPointIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneGeoPointIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneGeoPointFieldCodec codec = new LuceneGeoPointFieldCodec(resolvedProjectable, resolvedSortable, (GeoPoint)this.indexNullAsValue);
        return new LuceneIndexFieldType<GeoPoint>(codec, new LuceneGeoPointFieldPredicateBuilderFactory(dslToIndexConverter, codec), new LuceneGeoPointFieldSortBuilderFactory(resolvedSortable), new LuceneGeoPointFieldProjectionBuilderFactory(resolvedProjectable, codec, indexToProjectionConverter, this.createFromDocumentRawConverter()));
    }

    @Override
    protected LuceneGeoPointIndexFieldTypeContext thisAsS() {
        return this;
    }
}

