/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneIntegerFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneIntegerIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneIntegerIndexFieldTypeContext, Integer> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneIntegerIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Integer.class);
    }

    public LuceneIntegerIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Integer> toIndexFieldType() {
        boolean resolvedSortable = LuceneIntegerIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneIntegerIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneIntegerFieldCodec codec = new LuceneIntegerFieldCodec(resolvedProjectable, resolvedSortable, (Integer)this.indexNullAsValue);
        return new LuceneIndexFieldType<Integer>(codec, new LuceneNumericFieldPredicateBuilderFactory<Integer, Integer>((ToDocumentFieldValueConverter<?, Integer>)dslToIndexConverter, (ToDocumentFieldValueConverter<Integer, Integer>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Integer, Integer>(resolvedSortable, (ToDocumentFieldValueConverter<?, Integer>)dslToIndexConverter, (ToDocumentFieldValueConverter<Integer, Integer>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Integer>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneIntegerIndexFieldTypeContext thisAsS() {
        return this;
    }
}

