/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.LocalDateTime;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalDateTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneLocalDateTimeIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneLocalDateTimeIndexFieldTypeContext, LocalDateTime> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneLocalDateTimeIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, LocalDateTime.class);
    }

    public LuceneLocalDateTimeIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<LocalDateTime> toIndexFieldType() {
        boolean resolvedSortable = LuceneLocalDateTimeIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneLocalDateTimeIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneLocalDateTimeFieldCodec codec = new LuceneLocalDateTimeFieldCodec(resolvedProjectable, resolvedSortable, (LocalDateTime)this.indexNullAsValue);
        return new LuceneIndexFieldType<LocalDateTime>(codec, new LuceneNumericFieldPredicateBuilderFactory<LocalDateTime, Long>((ToDocumentFieldValueConverter<?, LocalDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDateTime, LocalDateTime>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<LocalDateTime, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, LocalDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDateTime, LocalDateTime>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<LocalDateTime>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneLocalDateTimeIndexFieldTypeContext thisAsS() {
        return this;
    }
}

