/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneAddEntryWork
extends AbstractLuceneWriteWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;
    private final String id;
    private final LuceneIndexEntry indexEntry;

    public LuceneAddEntryWork(String indexName, String tenantId, String id, LuceneIndexEntry indexEntry) {
        super("addEntry", indexName);
        this.tenantId = tenantId;
        this.id = id;
        this.indexEntry = indexEntry;
    }

    @Override
    public Long execute(LuceneWriteWorkExecutionContext context) {
        try {
            IndexWriterDelegator indexWriterDelegator = context.getIndexWriterDelegator();
            return indexWriterDelegator.addDocuments(this.indexEntry);
        }
        catch (IOException e) {
            throw log.unableToIndexEntry(this.tenantId, this.id, this.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", entry=").append(this.indexEntry).append("]");
        return sb.toString();
    }
}

