/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneExplainWork
implements LuceneReadWork<Explanation> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<String> indexNames;
    private final Query luceneQuery;
    private final String indexName;
    private final String documentId;
    private final Query explainedDocumentQuery;

    LuceneExplainWork(Set<String> indexNames, Query luceneQuery, String explainedDocumentIndexName, String explainedDocumentId, Query explainedDocumentQuery) {
        this.indexNames = indexNames;
        this.luceneQuery = luceneQuery;
        this.indexName = explainedDocumentIndexName;
        this.documentId = explainedDocumentId;
        this.explainedDocumentQuery = explainedDocumentQuery;
    }

    @Override
    public Explanation execute(LuceneReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = new IndexSearcher(context.getIndexReader());
            int luceneDocId = this.getLuceneDocId(indexSearcher);
            return indexSearcher.explain(this.luceneQuery, luceneDocId);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.luceneQuery, context.getEventContext(), e);
        }
    }

    private int getLuceneDocId(IndexSearcher indexSearcher) throws IOException {
        TopDocs topDocs = indexSearcher.search(this.explainedDocumentQuery, 1);
        if (topDocs.scoreDocs.length != 1) {
            throw log.explainUnkownDocument(this.indexName, this.documentId);
        }
        return topDocs.scoreDocs[0].doc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("indexNames=").append(this.indexNames).append(", luceneQuery=").append(this.luceneQuery).append(", explainedDocumentQuery=").append(this.explainedDocumentQuery).append("]");
        return sb.toString();
    }
}

