/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorProvider;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractor;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchWork<H>
implements LuceneReadWork<LuceneLoadableSearchResult<H>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<String> indexNames;
    private final Query luceneQuery;
    private final Sort luceneSort;
    private final int offset;
    private final Integer limit;
    private final LuceneCollectorProvider luceneCollectorProvider;
    private final LuceneSearchResultExtractor<H> searchResultExtractor;

    LuceneSearchWork(Set<String> indexNames, Query luceneQuery, Sort luceneSort, Integer offset, Integer limit, LuceneCollectorProvider luceneCollectorProvider, LuceneSearchResultExtractor<H> searchResultExtractor) {
        this.indexNames = indexNames;
        this.luceneQuery = luceneQuery;
        this.luceneSort = luceneSort;
        this.offset = offset == null ? 0 : offset;
        this.limit = limit;
        this.luceneCollectorProvider = luceneCollectorProvider;
        this.searchResultExtractor = searchResultExtractor;
    }

    @Override
    public LuceneLoadableSearchResult<H> execute(LuceneReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = new IndexSearcher(context.getIndexReader());
            LuceneCollectorsBuilder luceneCollectorsBuilder = new LuceneCollectorsBuilder(this.luceneSort, this.getMaxDocs(context));
            this.luceneCollectorProvider.contributeCollectors(luceneCollectorsBuilder);
            LuceneCollectors luceneCollectors = luceneCollectorsBuilder.build();
            luceneCollectors.collect(indexSearcher, this.luceneQuery, this.offset, this.limit);
            SearchProjectionExtractContext projectionExecutionContext = new SearchProjectionExtractContext(indexSearcher, this.luceneQuery, luceneCollectors.getDistanceCollectors());
            return this.searchResultExtractor.extract(indexSearcher, luceneCollectors.getTotalHits(), luceneCollectors.getTopDocs(), projectionExecutionContext);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.luceneQuery, context.getEventContext(), e);
        }
    }

    private int getMaxDocs(LuceneReadWorkExecutionContext context) {
        IndexReader reader = context.getIndexReader();
        if (this.limit == null) {
            return reader.maxDoc();
        }
        if ((long)this.limit.intValue() == 0L) {
            return 0;
        }
        return Math.min(this.offset + this.limit, reader.maxDoc());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("indexNames=").append(this.indexNames).append(", luceneQuery=").append(this.luceneQuery).append(", luceneSort=").append(this.luceneSort).append(", offset=").append(this.offset).append(", limit=").append(this.limit).append("]");
        return sb.toString();
    }
}

