/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.impl.LuceneIndexScope;
import org.hibernate.search.backend.lucene.search.dsl.predicate.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.dsl.predicate.impl.LuceneSearchPredicateFactoryImpl;
import org.hibernate.search.backend.lucene.search.dsl.projection.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.dsl.projection.impl.LuceneSearchProjectionFactoryImpl;
import org.hibernate.search.backend.lucene.search.dsl.query.LuceneSearchQueryHitTypeStep;
import org.hibernate.search.backend.lucene.search.dsl.query.impl.LuceneSearchQueryHitTypeStepImpl;
import org.hibernate.search.backend.lucene.search.dsl.sort.LuceneSearchSortFactory;
import org.hibernate.search.backend.lucene.search.dsl.sort.impl.LuceneSearchSortFactoryImpl;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactory;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactory;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryExtension;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactory;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.dsl.query.SearchQueryDslExtension;
import org.hibernate.search.engine.search.dsl.query.SearchQueryHitTypeStep;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactory;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneExtension<H, R, E>
implements SearchQueryDslExtension<LuceneSearchQueryHitTypeStep<R, E>, R, E>,
SearchQueryExtension<LuceneSearchQuery<H>, H>,
SearchPredicateFactoryExtension<LuceneSearchPredicateFactory>,
SearchSortFactoryExtension<LuceneSearchSortFactory>,
SearchProjectionFactoryExtension<LuceneSearchProjectionFactory<R, E>, R, E>,
IndexFieldTypeFactoryExtension<LuceneIndexFieldTypeFactory> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final LuceneExtension<Object, Object, Object> INSTANCE = new LuceneExtension();

    public static <H, R, E> LuceneExtension<H, R, E> get() {
        return INSTANCE;
    }

    private LuceneExtension() {
    }

    public Optional<LuceneSearchQueryHitTypeStep<R, E>> extendOptional(SearchQueryHitTypeStep<?, R, E, ?, ?> original, IndexScope<?> indexScope, SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        if (indexScope instanceof LuceneIndexScope) {
            return Optional.of(new LuceneSearchQueryHitTypeStepImpl<R, E>((LuceneIndexScope)indexScope, sessionContext, loadingContextBuilder));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchQuery<H>> extendOptional(SearchQuery<H> original, LoadingContext<?, ?> loadingContext) {
        if (original instanceof LuceneSearchQuery) {
            return Optional.of((LuceneSearchQuery)original);
        }
        return Optional.empty();
    }

    public <C, B> Optional<LuceneSearchPredicateFactory> extendOptional(SearchPredicateFactory original, SearchPredicateBuilderFactory<C, B> factory) {
        if (factory instanceof LuceneSearchPredicateBuilderFactory) {
            return Optional.of(new LuceneSearchPredicateFactoryImpl(original, (LuceneSearchPredicateBuilderFactory)factory));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchSortFactory> extendOptional(SearchSortFactory original, SearchSortDslContext<?, ?> dslContext) {
        if (dslContext.getBuilderFactory() instanceof LuceneSearchSortBuilderFactory) {
            return Optional.of(new LuceneSearchSortFactoryImpl(original, dslContext));
        }
        return Optional.empty();
    }

    public Optional<LuceneSearchProjectionFactory<R, E>> extendOptional(SearchProjectionFactory<R, E> original, SearchProjectionBuilderFactory factory) {
        if (factory instanceof LuceneSearchProjectionBuilderFactory) {
            return Optional.of(new LuceneSearchProjectionFactoryImpl<R, E>(original, (LuceneSearchProjectionBuilderFactory)factory));
        }
        return Optional.empty();
    }

    public LuceneIndexFieldTypeFactory extendOrFail(IndexFieldTypeFactory original) {
        if (original instanceof LuceneIndexFieldTypeFactory) {
            return (LuceneIndexFieldTypeFactory)original;
        }
        throw log.luceneExtensionOnUnknownType(original);
    }
}

