/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisComponentParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisOptionalComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.DelegatingAnalysisDefinitionContainerContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneAnalysisComponentParametersStep<T>
extends DelegatingAnalysisDefinitionContainerContext
implements LuceneAnalysisComponentParametersStep,
LuceneAnalysisComponentBuilder<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneAnalysisOptionalComponentsStep parentStep;
    final Map<String, String> params = new LinkedHashMap<String, String>();

    AbstractLuceneAnalysisComponentParametersStep(LuceneAnalysisOptionalComponentsStep parentStep) {
        super(parentStep);
        this.parentStep = parentStep;
    }

    @Override
    public LuceneAnalysisComponentParametersStep param(String name, String value) {
        String previous = this.params.putIfAbsent(name, value);
        if (previous != null) {
            throw log.analysisComponentParameterConflict(name, previous, value);
        }
        return this;
    }

    @Override
    public LuceneAnalysisComponentParametersStep charFilter(Class<? extends CharFilterFactory> factory) {
        return this.parentStep.charFilter(factory);
    }

    @Override
    public LuceneAnalysisComponentParametersStep tokenFilter(Class<? extends TokenFilterFactory> factory) {
        return this.parentStep.tokenFilter(factory);
    }
}

