/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurationContext;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerTokenizerStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerTypeStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneNormalizerOptionalComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneNormalizerTypeStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerInstanceBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneNormalizerComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneNormalizerInstanceBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionCollector;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionContributor;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneAnalysisConfigurationContextImpl
implements LuceneAnalysisConfigurationContext,
LuceneAnalysisDefinitionContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneAnalysisComponentFactory factory;
    private final Map<String, LuceneAnalyzerBuilder> analyzers = new LinkedHashMap<String, LuceneAnalyzerBuilder>();
    private final Map<String, LuceneAnalyzerBuilder> normalizers = new LinkedHashMap<String, LuceneAnalyzerBuilder>();

    public LuceneAnalysisConfigurationContextImpl(LuceneAnalysisComponentFactory factory) {
        this.factory = factory;
    }

    @Override
    public LuceneAnalyzerTypeStep analyzer(final String name) {
        return new LuceneAnalyzerTypeStep(){

            @Override
            public LuceneAnalyzerTokenizerStep custom() {
                LuceneAnalyzerComponentsStep definition = new LuceneAnalyzerComponentsStep(LuceneAnalysisConfigurationContextImpl.this, name);
                LuceneAnalysisConfigurationContextImpl.this.addAnalyzer(name, definition);
                return definition;
            }

            @Override
            public LuceneAnalysisConfigurationContext instance(Analyzer instance) {
                LuceneAnalyzerInstanceBuilder definition = new LuceneAnalyzerInstanceBuilder(instance);
                LuceneAnalysisConfigurationContextImpl.this.addAnalyzer(name, definition);
                return LuceneAnalysisConfigurationContextImpl.this;
            }
        };
    }

    @Override
    public LuceneNormalizerTypeStep normalizer(final String name) {
        return new LuceneNormalizerTypeStep(){

            @Override
            public LuceneNormalizerOptionalComponentsStep custom() {
                LuceneNormalizerComponentsStep definition = new LuceneNormalizerComponentsStep(LuceneAnalysisConfigurationContextImpl.this, name);
                LuceneAnalysisConfigurationContextImpl.this.addNormalizer(name, definition);
                return definition;
            }

            @Override
            public LuceneAnalysisConfigurationContext instance(Analyzer instance) {
                LuceneNormalizerInstanceBuilder definition = new LuceneNormalizerInstanceBuilder(name, instance);
                LuceneAnalysisConfigurationContextImpl.this.addNormalizer(name, definition);
                return LuceneAnalysisConfigurationContextImpl.this;
            }
        };
    }

    @Override
    public void contribute(LuceneAnalysisDefinitionCollector collector) {
        for (Map.Entry<String, LuceneAnalyzerBuilder> entry : this.analyzers.entrySet()) {
            collector.collectAnalyzer(entry.getKey(), entry.getValue().build(this.factory));
        }
        for (Map.Entry<String, LuceneAnalyzerBuilder> entry : this.normalizers.entrySet()) {
            collector.collectNormalizer(entry.getKey(), entry.getValue().build(this.factory));
        }
    }

    private void addAnalyzer(String name, LuceneAnalyzerBuilder definition) {
        LuceneAnalysisComponentBuilder existing = this.analyzers.putIfAbsent(name, definition);
        if (existing != null) {
            throw log.analyzerDefinitionNamingConflict(name);
        }
    }

    private void addNormalizer(String name, LuceneAnalyzerBuilder definition) {
        LuceneAnalysisComponentBuilder existing = this.normalizers.putIfAbsent(name, definition);
        if (existing != null) {
            throw log.normalizerDefinitionNamingConflict(name);
        }
    }
}

