/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaFieldNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectNodeBuilder,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, LuceneIndexSchemaNodeContributor> content = new LinkedHashMap<String, LuceneIndexSchemaNodeContributor>();

    AbstractLuceneIndexSchemaObjectNodeBuilder() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> addField(String relativeFieldName, IndexFieldType<F> indexFieldType) {
        LuceneIndexFieldType luceneIndexFieldType = (LuceneIndexFieldType)indexFieldType;
        LuceneIndexSchemaFieldNodeBuilder childBuilder = new LuceneIndexSchemaFieldNodeBuilder(this, relativeFieldName, luceneIndexFieldType);
        this.putField(relativeFieldName, childBuilder);
        return childBuilder;
    }

    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> createExcludedField(String relativeFieldName, IndexFieldType<F> indexFieldType) {
        LuceneIndexFieldType luceneIndexFieldType = (LuceneIndexFieldType)indexFieldType;
        return new LuceneIndexSchemaFieldNodeBuilder(this, relativeFieldName, luceneIndexFieldType);
    }

    public IndexSchemaObjectFieldNodeBuilder addObjectField(String relativeFieldName, ObjectFieldStorage storage) {
        LuceneIndexSchemaObjectFieldNodeBuilder objectFieldBuilder = new LuceneIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, storage);
        this.putField(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaObjectFieldNodeBuilder createExcludedObjectField(String relativeFieldName, ObjectFieldStorage storage) {
        return new LuceneIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, storage);
    }

    public abstract LuceneIndexSchemaRootNodeBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    final void contributeChildren(LuceneIndexSchemaObjectNode node, LuceneIndexSchemaNodeCollector collector) {
        for (LuceneIndexSchemaNodeContributor contributor : this.content.values()) {
            contributor.contribute(collector, node);
        }
    }

    private void putField(String name, LuceneIndexSchemaNodeContributor contributor) {
        LuceneIndexSchemaNodeContributor previous = this.content.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaNodeNameConflict(name, this.getEventContext());
        }
    }
}

