/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerImpl;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class LuceneIndexManagerBuilder
implements IndexManagerBuilder<LuceneRootDocumentBuilder> {
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String indexName;
    private final LuceneIndexSchemaRootNodeBuilder schemaRootNodeBuilder;

    public LuceneIndexManagerBuilder(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String indexName, LuceneIndexSchemaRootNodeBuilder schemaRootNodeBuilder) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.indexName = indexName;
        this.schemaRootNodeBuilder = schemaRootNodeBuilder;
    }

    public void closeOnFailure() {
    }

    public IndexSchemaRootNodeBuilder getSchemaRootNodeBuilder() {
        return this.schemaRootNodeBuilder;
    }

    public LuceneIndexManagerImpl build() {
        LuceneIndexModel model = null;
        IndexAccessor indexAccessor = null;
        try {
            model = this.schemaRootNodeBuilder.build(this.indexName);
            indexAccessor = this.indexingBackendContext.createIndexAccessor(model.getIndexName(), (Analyzer)model.getScopedAnalyzer());
            return new LuceneIndexManagerImpl(this.indexingBackendContext, this.searchBackendContext, this.indexName, model, indexAccessor);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)model).push(indexAccessor);
            throw e;
        }
    }
}

