/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexScopeBuilder;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexManagerImpl
implements IndexManagerImplementor<LuceneRootDocumentBuilder>,
LuceneIndexManager,
ReaderProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String indexName;
    private final LuceneIndexModel model;
    private final LuceneWriteWorkOrchestratorImplementor writeOrchestrator;
    private final IndexAccessor indexAccessor;

    LuceneIndexManagerImpl(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String indexName, LuceneIndexModel model, IndexAccessor indexAccessor) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.indexName = indexName;
        this.model = model;
        this.writeOrchestrator = indexingBackendContext.createOrchestrator(indexName, indexAccessor.getIndexWriterDelegator());
        this.indexAccessor = indexAccessor;
    }

    LuceneIndexModel getModel() {
        return this.model;
    }

    public void start(IndexManagerStartContext context) {
        this.writeOrchestrator.start();
    }

    public IndexWorkPlan<LuceneRootDocumentBuilder> createWorkPlan(SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.indexingBackendContext.createWorkPlan(this.writeOrchestrator, this.indexName, sessionContext, commitStrategy, refreshStrategy);
    }

    public IndexDocumentWorkExecutor<LuceneRootDocumentBuilder> createDocumentWorkExecutor(SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        return this.indexingBackendContext.createDocumentWorkExecutor(this.writeOrchestrator, this.indexName, sessionContext, commitStrategy);
    }

    public IndexWorkExecutor createWorkExecutor(DetachedSessionContextImplementor sessionContext) {
        return this.indexingBackendContext.createWorkExecutor(this.writeOrchestrator, this.indexName, sessionContext);
    }

    public IndexScopeBuilder createScopeBuilder(MappingContextImplementor mappingContext) {
        return new LuceneIndexScopeBuilder(this.searchBackendContext, mappingContext, this);
    }

    public void addTo(IndexScopeBuilder builder) {
        if (!(builder instanceof LuceneIndexScopeBuilder)) {
            throw log.cannotMixLuceneScopeWithOtherType(builder, this, this.searchBackendContext.getEventContext());
        }
        LuceneIndexScopeBuilder luceneBuilder = (LuceneIndexScopeBuilder)builder;
        luceneBuilder.add(this.searchBackendContext, this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.indexName + "]";
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(LuceneWriteWorkOrchestratorImplementor::close, (Object)this.writeOrchestrator);
            closer.push(IndexAccessor::close, (Object)this.indexAccessor);
            closer.push(LuceneIndexModel::close, (Object)this.model);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.getBackendAndIndexEventContext());
        }
    }

    ReaderProvider getReaderProvider() {
        return this;
    }

    @Override
    public IndexReader openIndexReader() {
        try {
            return this.indexAccessor.openDirectoryIndexReader();
        }
        catch (IOException e) {
            throw log.unableToCreateIndexReader(this.getBackendAndIndexEventContext(), e);
        }
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            log.unableToCloseIndexReader(this.getBackendAndIndexEventContext(), e);
        }
    }

    public IndexManager toAPI() {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(LuceneIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, LuceneIndexManager.class, this.getBackendAndIndexEventContext());
    }

    public final IndexAccessor getIndexAccessorForTests() {
        return this.indexAccessor;
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.indexingBackendContext.getEventContext().append(EventContexts.fromIndexName((String)this.indexName));
    }
}

