/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String couldNotCloseResource = "HSEARCH000035: Could not close resource.";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String forcingReleaseIndexWriterLock = "HSEARCH000052: Going to force release of the IndexWriter lock. %1$s";
    private static final String unableToCloseIndexReader = "HSEARCH000055: Unable to close the index reader. %1$s";
    private static final String recommendConfiguringLuceneVersion = "HSEARCH000075: Configuration setting '%1$s' was not specified: using LATEST (currently '%2$s'). %3$s";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String exceptionDuringIndexMergeOperation = "HSEARCH000118: Exception during index Merge operation";
    private static final String lockingFailureDuringInitialization = "HSEARCH000225: An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.";
    private static final String illegalLuceneVersionFormat = "HSEARCH000228: Value '%1$ss' is not in a valid format to express a Lucene version: %2$s";
    private static final String ioExceptionOnMultiReaderRefresh = "HSEARCH000284: An IOException happened while opening multiple indexes.";
    private static final String couldNotNormalizeField = "HSEARCH000320: Could not normalize value for field '%1$s'.";
    private static final String multipleTermsDetectedDuringNormalization = "HSEARCH000321: The analysis of field '%1$s' produced multiple tokens. Tokenization or term generation (synonyms) should not be used on sortable fields or range queries. Only the first token will be considered.";
    private static final String unableToApplyAnalysisConfiguration = "HSEARCH000329: Error while applying analysis configuration: %1$s";
    private static final String analyzerDefinitionNamingConflict = "HSEARCH000330: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    private static final String analysisComponentParameterConflict = "HSEARCH000337: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    private static final String normalizerDefinitionNamingConflict = "HSEARCH000341: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    private static final String cannotApplyAnalyzerAndNormalizer = "HSEARCH000342: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    private static final String normalizerProducedMultipleTokens = "HSEARCH000344: The normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    private static final String cannotUseAnalyzerOnSortableField = "HSEARCH000345: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    private static final String unknownAnalyzer = "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    private static final String unknownFieldForSearch = "HSEARCH600000: Unknown field '%1$s'.";
    private static final String pathIsNotWriteableDirectory = "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    private static final String unableToInitializeRootDirectory = "HSEARCH600002: Unable to initialize root directory '%1$s': %2$s";
    private static final String luceneExtensionOnUnknownType = "HSEARCH600005: The Lucene extension can only be applied to objects derived from the Lucene backend. Was applied to '%1$s' instead.";
    private static final String cannotMixLuceneSearchQueryWithOtherPredicates = "HSEARCH600010: A Lucene query cannot include search predicates built using a non-Lucene search scope. Given predicate was: '%1$s'";
    private static final String nonObjectFieldForNestedQuery = "HSEARCH600012: Field '%1$s' is not an object field.";
    private static final String nonNestedFieldForNestedQuery = "HSEARCH600013: Object field '%1$s' is not stored as nested.";
    private static final String cannotMixLuceneSearchSortWithOtherSorts = "HSEARCH600014: A Lucene query cannot include search sorts built using a non-Lucene search scope. Given sort was: '%1$s'";
    private static final String unableToInitializeIndexDirectory = "HSEARCH600015: Unable to initialize index directory: %1$s";
    private static final String unableToIndexEntry = "HSEARCH600016: Unable to index entry '%2$s' with tenant identifier '%1$s'.";
    private static final String unableToDeleteEntryFromIndex = "HSEARCH600017: Unable to delete entry '%2$s' with tenant identifier '%1$s'.";
    private static final String unableToFlushIndex = "HSEARCH600018: Unable to flush.";
    private static final String unableToCommitIndex = "HSEARCH600019: Unable to commit.";
    private static final String unableToCreateIndexReader = "HSEARCH600022: Could not open an index reader.";
    private static final String cannotMixLuceneScopeWithOtherType = "HSEARCH600024: A multi-index scope cannot include both a Lucene index and another type of index. Base scope was: '%1$s', Lucene index was: '%2$s'";
    private static final String cannotMixLuceneScopeWithOtherBackend = "HSEARCH600025: A multi-index scope cannot span multiple Lucene backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    private static final String ioExceptionOnQueryExecution = "HSEARCH600027: An IOException happened while executing the query '%1$s'.";
    private static final String multiTenancyRequiredButNotSupportedByBackend = "HSEARCH600029: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    private static final String invalidMultiTenancyStrategyName = "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    private static final String tenantIdProvidedButMultiTenancyDisabled = "HSEARCH600031: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    private static final String multiTenancyEnabledButNoTenantIdProvided = "HSEARCH600032: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    private static final String backendUnwrappingWithUnknownType = "HSEARCH600033: Attempt to unwrap a Lucene backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    private static final String indexSchemaNodeNameConflict = "HSEARCH600034: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    private static final String rangePredicatesNotSupportedByGeoPoint = "HSEARCH600037: Range predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    private static final String matchPredicatesNotSupportedByGeoPoint = "HSEARCH600038: Match predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    private static final String invalidFieldForDocumentElement = "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    private static final String spatialPredicatesNotSupportedByFieldType = "HSEARCH600040: Spatial predicates are not supported by this field's type.";
    private static final String distanceOperationsNotSupportedByFieldType = "HSEARCH600041: Distance related operations are not supported by this field's type.";
    private static final String traditionalSortNotSupportedByGeoPoint = "HSEARCH600042: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    private static final String descendingOrderNotSupportedByDistanceSort = "HSEARCH600043: Descending order is not supported for distance sort.";
    private static final String minimumShouldMatchMinimumOutOfBounds = "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    private static final String minimumShouldMatchConflictingConstraints = "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    private static final String unsupportedDSLPredicates = "HSEARCH600046: Native fields do not support defining predicates with the DSL: use the Lucene extension and a native query.";
    private static final String unsupportedDSLSorts = "HSEARCH600047: Native fields do not support defining sorts with the DSL: use the Lucene extension and a native sort.";
    private static final String unsupportedProjection = "HSEARCH600048: This native field does not support projection.";
    private static final String invalidFieldPath = "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    private static final String cannotConvertDslParameter = "HSEARCH600050: Unable to convert DSL parameter: %1$s";
    private static final String indexManagerUnwrappingWithUnknownType = "HSEARCH600051: Attempt to unwrap a Lucene index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    private static final String unableToCreateAnalyzer = "HSEARCH600052: Unable to create analyzer for name '%1$s'.";
    private static final String unableToCreateNormalizer = "HSEARCH600053: Unable to create normalizer for name '%1$s'.";
    private static final String unknownNormalizer = "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    private static final String cannotMixLuceneSearchQueryWithOtherProjections = "HSEARCH600055: A Lucene query cannot include search projections built using a non-Lucene search scope. Given projection was: '%1$s'";
    private static final String invalidProjectionInvalidType = "HSEARCH600056: Invalid type '%2$s' for projection on field '%1$s'.";
    private static final String unsupportedDSLProjections = "HSEARCH600057: This field does not support projections.";
    private static final String conflictingFieldTypesForPredicate = "HSEARCH600058: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String conflictingFieldTypesForSort = "HSEARCH600059: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String conflictingFieldTypesForProjection = "HSEARCH600060: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    private static final String failedToShutdownBackend = "HSEARCH600061: Failed to shut down the Lucene index manager.";
    private static final String cannotGuessFieldType = "HSEARCH600062: Cannot guess field type for input type: '%1$s'.";
    private static final String documentIdNotCollected = "HSEARCH600064: Unexpected index: documentId '%1$s' was not collected.";
    private static final String nonProjectableField = "HSEARCH600065: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    private static final String unsortableField = "HSEARCH600066: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    private static final String unableToDeleteAllEntriesFromIndex = "HSEARCH600067: Unable to delete all entries with tenant identifier '%1$s'.";
    private static final String conflictingIdentifierTypesForPredicate = "HSEARCH600068: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    private static final String ioExceptionOnExplain = "HSEARCH600069: An IOException occurred while generating an Explanation.";
    private static final String textPredicatesNotSupportedByFieldType = "HSEARCH600070: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    private static final String incompleteFieldDefinition = "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    private static final String cannotCreateReferenceMultipleTimes = "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    private static final String cannotUseIndexNullAsAndAnalyzer = "HSEARCH600073: Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.";
    private static final String multipleValuesForSingleValuedField = "HSEARCH600074: Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.";
    private static final String explainRequiresIndexName = "HSEARCH600075: explain(String id) cannot be used when the query targets multiple indexes. Use explain(String indexName, String id) and pass one of %1$s as the index name.";
    private static final String explainRequiresIndexTargetedByQuery = "HSEARCH600076: The given index name '%2$s' is not among the indexes targeted by this query: %1$s.";
    private static final String explainUnkownDocument = "HSEARCH600077: Document with id '%2$s' does not exist in index '%1$s' and thus its match cannot be explained.";
    private static final String unableToOptimizeIndex = "HSEARCH600078: Unable to optimize.";
    private static final String unableToCleanUpAfterError = "HSEARCH600079: Unable to clean up after write errors.";
    private static final String nullDecimalScale = "HSEARCH600080: Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.";
    private static final String scaledNumberTooLarge = "HSEARCH600081: The value '%1$s' cannot be indexed because its absolute value is too large.";
    private static final String invalidDecimalScale = "HSEARCH600082: Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.";
    private static final String nonSearchableField = "HSEARCH600083: Field '%1$s' is not searchable. Make sure the field is marked as searchable.";
    private static final String predicateDefinedOnDifferentIndexes = "HSEARCH600084: The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    private static final String sortDefinedOnDifferentIndexes = "HSEARCH600085: The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    private static final String projectionDefinedOnDifferentIndexes = "HSEARCH600086: The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    private static final String invalidFileSystemAccessStrategyName = "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    private static final String invalidLockingStrategyName = "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void couldNotCloseResource(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotCloseResource$str(), new Object[0]);
    }

    protected String couldNotCloseResource$str() {
        return couldNotCloseResource;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(String name, InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.interruptedWhileWaitingForIndexActivity$str(), (Object)name);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    @Override
    public final void forcingReleaseIndexWriterLock(EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.forcingReleaseIndexWriterLock$str(), (Object)new EventContextFormatter(context));
    }

    protected String forcingReleaseIndexWriterLock$str() {
        return forcingReleaseIndexWriterLock;
    }

    @Override
    public final void unableToCloseIndexReader(EventContext context, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseIndexReader$str(), (Object)new EventContextFormatter(context));
    }

    protected String unableToCloseIndexReader$str() {
        return unableToCloseIndexReader;
    }

    @Override
    public final void recommendConfiguringLuceneVersion(String key, Version latest, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.recommendConfiguringLuceneVersion$str(), (Object)key, (Object)latest, (Object)new EventContextFormatter(context));
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return recommendConfiguringLuceneVersion;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String exceptionDuringIndexMergeOperation$str() {
        return exceptionDuringIndexMergeOperation;
    }

    @Override
    public final String exceptionDuringIndexMergeOperation() {
        return String.format(this.getLoggingLocale(), this.exceptionDuringIndexMergeOperation$str(), new Object[0]);
    }

    @Override
    public final void lockingFailureDuringInitialization(String directoryDescription, EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lockingFailureDuringInitialization$str(), (Object)directoryDescription);
    }

    protected String lockingFailureDuringInitialization$str() {
        return lockingFailureDuringInitialization;
    }

    protected String illegalLuceneVersionFormat$str() {
        return illegalLuceneVersionFormat;
    }

    @Override
    public final SearchException illegalLuceneVersionFormat(String property, String luceneErrorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalLuceneVersionFormat$str(), property, luceneErrorMessage), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnMultiReaderRefresh$str() {
        return ioExceptionOnMultiReaderRefresh;
    }

    @Override
    public final SearchException ioExceptionOnMultiReaderRefresh(EventContext context, IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnMultiReaderRefresh$str(), new Object[0]), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotNormalizeField$str() {
        return couldNotNormalizeField;
    }

    @Override
    public final SearchException couldNotNormalizeField(String absoluteFieldPath, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.couldNotNormalizeField$str(), absoluteFieldPath), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void multipleTermsDetectedDuringNormalization(String absoluteFieldPath) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleTermsDetectedDuringNormalization$str(), (Object)absoluteFieldPath);
    }

    protected String multipleTermsDetectedDuringNormalization$str() {
        return multipleTermsDetectedDuringNormalization;
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return unableToApplyAnalysisConfiguration;
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analyzerDefinitionNamingConflict$str() {
        return analyzerDefinitionNamingConflict;
    }

    @Override
    public final SearchException analyzerDefinitionNamingConflict(String analyzerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerDefinitionNamingConflict$str(), analyzerDefinitionName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return analysisComponentParameterConflict;
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, String value1, String value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String normalizerDefinitionNamingConflict$str() {
        return normalizerDefinitionNamingConflict;
    }

    @Override
    public final SearchException normalizerDefinitionNamingConflict(String normalizerDefinitionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerDefinitionNamingConflict$str(), normalizerDefinitionName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return cannotApplyAnalyzerAndNormalizer;
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void normalizerProducedMultipleTokens(String normalizerName, int token) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.normalizerProducedMultipleTokens$str(), (Object)normalizerName, (Object)token);
    }

    protected String normalizerProducedMultipleTokens$str() {
        return normalizerProducedMultipleTokens;
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return cannotUseAnalyzerOnSortableField;
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAnalyzer$str() {
        return unknownAnalyzer;
    }

    @Override
    public final SearchException unknownAnalyzer(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAnalyzer$str(), analyzerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return unknownFieldForSearch;
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String pathIsNotWriteableDirectory$str() {
        return pathIsNotWriteableDirectory;
    }

    @Override
    public final SearchException pathIsNotWriteableDirectory(Path rootDirectory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.pathIsNotWriteableDirectory$str(), rootDirectory));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeRootDirectory$str() {
        return unableToInitializeRootDirectory;
    }

    @Override
    public final SearchException unableToInitializeRootDirectory(Path rootDirectory, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeRootDirectory$str(), rootDirectory, causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String luceneExtensionOnUnknownType$str() {
        return luceneExtensionOnUnknownType;
    }

    @Override
    public final SearchException luceneExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.luceneExtensionOnUnknownType$str(), context));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return cannotMixLuceneSearchQueryWithOtherPredicates;
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonObjectFieldForNestedQuery$str() {
        return nonObjectFieldForNestedQuery;
    }

    @Override
    public final SearchException nonObjectFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonNestedFieldForNestedQuery$str() {
        return nonNestedFieldForNestedQuery;
    }

    @Override
    public final SearchException nonNestedFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return cannotMixLuceneSearchSortWithOtherSorts;
    }

    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeIndexDirectory$str() {
        return unableToInitializeIndexDirectory;
    }

    @Override
    public final SearchException unableToInitializeIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToIndexEntry$str() {
        return unableToIndexEntry;
    }

    @Override
    public final SearchException unableToIndexEntry(String tenantId, String id, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToIndexEntry$str(), tenantId, id), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeleteEntryFromIndex$str() {
        return unableToDeleteEntryFromIndex;
    }

    @Override
    public final SearchException unableToDeleteEntryFromIndex(String tenantId, String id, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteEntryFromIndex$str(), tenantId, id), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFlushIndex$str() {
        return unableToFlushIndex;
    }

    @Override
    public final SearchException unableToFlushIndex(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToFlushIndex$str(), new Object[0]), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCommitIndex$str() {
        return unableToCommitIndex;
    }

    @Override
    public final SearchException unableToCommitIndex(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCommitIndex$str(), new Object[0]), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateIndexReader$str() {
        return unableToCreateIndexReader;
    }

    @Override
    public final SearchException unableToCreateIndexReader(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateIndexReader$str(), new Object[0]), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherType$str() {
        return cannotMixLuceneScopeWithOtherType;
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder baseScope, LuceneIndexManager luceneIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return cannotMixLuceneScopeWithOtherBackend;
    }

    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder baseScope, LuceneIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnQueryExecution$str() {
        return ioExceptionOnQueryExecution;
    }

    @Override
    public final SearchException ioExceptionOnQueryExecution(Query luceneQuery, EventContext context, IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnQueryExecution$str(), luceneQuery), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return multiTenancyRequiredButNotSupportedByBackend;
    }

    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(String indexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return invalidMultiTenancyStrategyName;
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return tenantIdProvidedButMultiTenancyDisabled;
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(String tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return multiTenancyEnabledButNoTenantIdProvided;
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return backendUnwrappingWithUnknownType;
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return indexSchemaNodeNameConflict;
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rangePredicatesNotSupportedByGeoPoint$str() {
        return rangePredicatesNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException rangePredicatesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangePredicatesNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String matchPredicatesNotSupportedByGeoPoint$str() {
        return matchPredicatesNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException matchPredicatesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.matchPredicatesNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return invalidFieldForDocumentElement;
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return spatialPredicatesNotSupportedByFieldType;
    }

    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.spatialPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String distanceOperationsNotSupportedByFieldType$str() {
        return distanceOperationsNotSupportedByFieldType;
    }

    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.distanceOperationsNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return traditionalSortNotSupportedByGeoPoint;
    }

    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.traditionalSortNotSupportedByGeoPoint$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String descendingOrderNotSupportedByDistanceSort$str() {
        return descendingOrderNotSupportedByDistanceSort;
    }

    @Override
    public final SearchException descendingOrderNotSupportedByDistanceSort(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.descendingOrderNotSupportedByDistanceSort$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return minimumShouldMatchMinimumOutOfBounds;
    }

    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(int totalShouldClauseNumber, int minimum) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return minimumShouldMatchConflictingConstraints;
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ignoreConstraintCeiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedDSLPredicates$str() {
        return unsupportedDSLPredicates;
    }

    @Override
    public final SearchException unsupportedDSLPredicates(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedDSLPredicates$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedDSLSorts$str() {
        return unsupportedDSLSorts;
    }

    @Override
    public final SearchException unsupportedDSLSorts(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedDSLSorts$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedProjection$str() {
        return unsupportedProjection;
    }

    @Override
    public final SearchException unsupportedProjection(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedProjection$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFieldPath$str() {
        return invalidFieldPath;
    }

    @Override
    public final SearchException invalidFieldPath(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldPath$str(), expectedPath, actualPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return cannotConvertDslParameter;
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return indexManagerUnwrappingWithUnknownType;
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateAnalyzer$str() {
        return unableToCreateAnalyzer;
    }

    @Override
    public final SearchException unableToCreateAnalyzer(String name, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateAnalyzer$str(), name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateNormalizer$str() {
        return unableToCreateNormalizer;
    }

    @Override
    public final SearchException unableToCreateNormalizer(String name, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCreateNormalizer$str(), name), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownNormalizer$str() {
        return unknownNormalizer;
    }

    @Override
    public final SearchException unknownNormalizer(String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNormalizer$str(), normalizerName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return cannotMixLuceneSearchQueryWithOtherProjections;
    }

    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidProjectionInvalidType$str() {
        return invalidProjectionInvalidType;
    }

    @Override
    public final SearchException invalidProjectionInvalidType(String absoluteFieldPath, Class<?> type, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidProjectionInvalidType$str(), absoluteFieldPath, new ClassFormatter(type)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedDSLProjections$str() {
        return unsupportedDSLProjections;
    }

    @Override
    public final SearchException unsupportedDSLProjections(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedDSLProjections$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForPredicate$str() {
        return conflictingFieldTypesForPredicate;
    }

    @Override
    public final SearchException conflictingFieldTypesForPredicate(String absoluteFieldPath, LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForSort$str() {
        return conflictingFieldTypesForSort;
    }

    @Override
    public final SearchException conflictingFieldTypesForSort(String absoluteFieldPath, LuceneFieldSortBuilderFactory component1, LuceneFieldSortBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingFieldTypesForProjection$str() {
        return conflictingFieldTypesForProjection;
    }

    @Override
    public final SearchException conflictingFieldTypesForProjection(String absoluteFieldPath, LuceneFieldProjectionBuilderFactory component1, LuceneFieldProjectionBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToShutdownBackend$str() {
        return failedToShutdownBackend;
    }

    @Override
    public final SearchException failedToShutdownBackend(Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownBackend$str(), new Object[0]), (Throwable)cause, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return cannotGuessFieldType;
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String documentIdNotCollected$str() {
        return documentIdNotCollected;
    }

    @Override
    public final SearchException documentIdNotCollected(Integer documentId) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.documentIdNotCollected$str(), documentId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonProjectableField$str() {
        return nonProjectableField;
    }

    @Override
    public final SearchException nonProjectableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonProjectableField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsortableField$str() {
        return unsortableField;
    }

    @Override
    public final SearchException unsortableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsortableField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeleteAllEntriesFromIndex$str() {
        return unableToDeleteAllEntriesFromIndex;
    }

    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(String tenantId, EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeleteAllEntriesFromIndex$str(), tenantId), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingIdentifierTypesForPredicate$str() {
        return conflictingIdentifierTypesForPredicate;
    }

    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(ToDocumentIdentifierValueConverter<?> component1, ToDocumentIdentifierValueConverter<?> component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnExplain$str() {
        return ioExceptionOnExplain;
    }

    @Override
    public final SearchException ioExceptionOnExplain(IOException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ioExceptionOnExplain$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String textPredicatesNotSupportedByFieldType$str() {
        return textPredicatesNotSupportedByFieldType;
    }

    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.textPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return incompleteFieldDefinition;
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return cannotCreateReferenceMultipleTimes;
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return cannotUseIndexNullAsAndAnalyzer;
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleValuesForSingleValuedField$str() {
        return multipleValuesForSingleValuedField;
    }

    @Override
    public final SearchException multipleValuesForSingleValuedField(String absoluteFieldPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String explainRequiresIndexName$str() {
        return explainRequiresIndexName;
    }

    @Override
    public final SearchException explainRequiresIndexName(Set<String> targetedIndexNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresIndexName$str(), targetedIndexNames));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String explainRequiresIndexTargetedByQuery$str() {
        return explainRequiresIndexTargetedByQuery;
    }

    @Override
    public final SearchException explainRequiresIndexTargetedByQuery(Set<String> targetedIndexNames, String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresIndexTargetedByQuery$str(), targetedIndexNames, indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String explainUnkownDocument$str() {
        return explainUnkownDocument;
    }

    @Override
    public final SearchException explainUnkownDocument(String indexName, String d) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnkownDocument$str(), indexName, d));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToOptimizeIndex$str() {
        return unableToOptimizeIndex;
    }

    @Override
    public final SearchException unableToOptimizeIndex(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToOptimizeIndex$str(), new Object[0]), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCleanUpAfterError$str() {
        return unableToCleanUpAfterError;
    }

    @Override
    public final SearchException unableToCleanUpAfterError(EventContext context, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCleanUpAfterError$str(), new Object[0]), (Throwable)e, context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullDecimalScale$str() {
        return nullDecimalScale;
    }

    @Override
    public final SearchException nullDecimalScale(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), new Object[0]), eventContext);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String scaledNumberTooLarge$str() {
        return scaledNumberTooLarge;
    }

    @Override
    public final SearchException scaledNumberTooLarge(Number value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.scaledNumberTooLarge$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDecimalScale$str() {
        return invalidDecimalScale;
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonSearchableField$str() {
        return nonSearchableField;
    }

    @Override
    public final SearchException nonSearchableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonSearchableField$str(), absoluteFieldPath), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return predicateDefinedOnDifferentIndexes;
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return sortDefinedOnDifferentIndexes;
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return projectionDefinedOnDifferentIndexes;
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFileSystemAccessStrategyName$str() {
        return invalidFileSystemAccessStrategyName;
    }

    @Override
    public final SearchException invalidFileSystemAccessStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLockingStrategyName$str() {
        return invalidLockingStrategyName;
    }

    @Override
    public final SearchException invalidLockingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

