/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.SleepingLockWrapper;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryCreationContext;
import org.hibernate.search.backend.lucene.util.impl.AnalyzerConstants;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class DirectoryCreationContextImpl
implements DirectoryCreationContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final String indexName;

    public DirectoryCreationContextImpl(EventContext eventContext, String indexName) {
        this.eventContext = eventContext;
        this.indexName = indexName;
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void initializeIndexIfNeeded(Directory directory) throws IOException {
        if (DirectoryReader.indexExists((Directory)directory)) {
            return;
        }
        try {
            IndexWriterConfig iwriterConfig = new IndexWriterConfig(AnalyzerConstants.KEYWORD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            SleepingLockWrapper delayedDirectory = new SleepingLockWrapper(directory, 2000L, 20L);
            IndexWriter iw = new IndexWriter((Directory)delayedDirectory, iwriterConfig);
            iw.close();
        }
        catch (LockObtainFailedException lofe) {
            log.lockingFailureDuringInitialization(directory.toString(), this.eventContext);
        }
    }
}

