/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.util.Optional;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.hibernate.search.backend.lucene.lowlevel.directory.LockingStrategyName;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProviderInitializationContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public class DirectoryProviderInitializationContextImpl
implements DirectoryProviderInitializationContext {
    private static final ConfigurationProperty<BeanReference<? extends DirectoryProvider>> TYPE = ConfigurationProperty.forKey((String)"type").asBeanReference(DirectoryProvider.class).withDefault((Object)BeanReference.of(DirectoryProvider.class, (String)"local-filesystem")).build();
    private static final OptionalConfigurationProperty<LockingStrategyName> LOCKING_STRATEGY = ConfigurationProperty.forKey((String)"locking.strategy").as(LockingStrategyName.class, LockingStrategyName::of).build();
    private final EventContext eventContext;
    private final BeanResolver beanResolver;
    private final ConfigurationPropertySource configurationPropertySource;

    public DirectoryProviderInitializationContextImpl(EventContext eventContext, BeanResolver beanResolver, ConfigurationPropertySource configurationPropertySource) {
        this.eventContext = eventContext;
        this.beanResolver = beanResolver;
        this.configurationPropertySource = configurationPropertySource;
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    @Override
    public ConfigurationPropertySource getConfigurationPropertySource() {
        return this.configurationPropertySource;
    }

    @Override
    public Optional<LockFactory> createConfiguredLockFactory() {
        return ((Optional)LOCKING_STRATEGY.get(this.configurationPropertySource)).map(DirectoryProviderInitializationContextImpl::createLockFactory);
    }

    public BeanHolder<? extends DirectoryProvider> createDirectoryProvider() {
        BeanHolder directoryProviderHolder = (BeanHolder)TYPE.getAndTransform(this.configurationPropertySource, arg_0 -> ((BeanResolver)this.beanResolver).resolve(arg_0));
        try {
            ((DirectoryProvider)directoryProviderHolder.get()).initialize(this);
            return directoryProviderHolder;
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((DirectoryProvider)holder.get()).close(), (Object)directoryProviderHolder)).push((AutoCloseable)directoryProviderHolder);
            throw e;
        }
    }

    private static LockFactory createLockFactory(LockingStrategyName name) {
        switch (name) {
            case SIMPLE_FILESYSTEM: {
                return SimpleFSLockFactory.INSTANCE;
            }
            case NATIVE_FILESYSTEM: {
                return NativeFSLockFactory.INSTANCE;
            }
            case SINGLE_INSTANCE: {
                return new SingleInstanceLockFactory();
            }
            case NONE: {
                return NoLockFactory.INSTANCE;
            }
        }
        throw new AssertionFailure("Unexpected name: " + (Object)((Object)name));
    }
}

