/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.LockFactory;
import org.hibernate.search.backend.lucene.cfg.LuceneBackendSettings;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.FileSystemAccessStrategyName;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.FileSystemAccessStrategy;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryCreationContext;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProviderInitializationContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LocalFileSystemDirectoryProvider
implements DirectoryProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "local-filesystem";
    private static final ConfigurationProperty<Path> ROOT = ConfigurationProperty.forKey((String)"root").as(Path.class, x$0 -> Paths.get(x$0, new String[0])).withDefault(() -> Paths.get(".", new String[0])).build();
    private static final ConfigurationProperty<FileSystemAccessStrategyName> FILESYSTEM_ACCESS_STRATEGY = ConfigurationProperty.forKey((String)"filesystem_access.strategy").as(FileSystemAccessStrategyName.class, FileSystemAccessStrategyName::of).withDefault((Object)LuceneBackendSettings.Defaults.DIRECTORY_FILESYSTEM_ACCESS_STRATEGY).build();
    private Path root;
    private FileSystemAccessStrategy accessStrategy;
    private LockFactory lockFactory;

    public String toString() {
        return this.getClass().getSimpleName() + "[root=" + this.root + "]";
    }

    @Override
    public void initialize(DirectoryProviderInitializationContext context) {
        ConfigurationPropertySource propertySource = context.getConfigurationPropertySource();
        this.root = ((Path)ROOT.get(propertySource)).toAbsolutePath();
        FileSystemAccessStrategyName accessStrategyName = (FileSystemAccessStrategyName)((Object)FILESYSTEM_ACCESS_STRATEGY.get(propertySource));
        this.accessStrategy = FileSystemAccessStrategy.get(accessStrategyName);
        this.lockFactory = context.createConfiguredLockFactory().orElseGet(FSLockFactory::getDefault);
        try {
            this.initializeWriteableDirectory(this.root);
        }
        catch (Exception e) {
            throw log.unableToInitializeRootDirectory(this.root, e.getMessage(), e);
        }
    }

    @Override
    public DirectoryHolder createDirectory(DirectoryCreationContext context) throws IOException {
        Path directoryPath = this.root.resolve(context.getIndexName());
        try {
            this.initializeWriteableDirectory(directoryPath);
        }
        catch (Exception e) {
            throw log.unableToInitializeIndexDirectory(e.getMessage(), context.getEventContext(), e);
        }
        FSDirectory directory = this.accessStrategy.createDirectory(directoryPath, this.lockFactory);
        try {
            context.initializeIndexIfNeeded((Directory)directory);
            return DirectoryHolder.of((Directory)directory);
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)directory);
            throw e;
        }
    }

    private void initializeWriteableDirectory(Path rootDirectory) throws IOException {
        if (Files.exists(rootDirectory, new LinkOption[0])) {
            if (!Files.isDirectory(rootDirectory, new LinkOption[0]) || !Files.isWritable(rootDirectory)) {
                throw log.pathIsNotWriteableDirectory(rootDirectory);
            }
        } else {
            Files.createDirectories(rootDirectory, new FileAttribute[0]);
        }
    }
}

