/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.io.IOException;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryCreationContext;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProviderInitializationContext;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class LocalHeapDirectoryProvider
implements DirectoryProvider {
    public static final String NAME = "local-heap";
    private LockFactory lockFactory;

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void initialize(DirectoryProviderInitializationContext context) {
        this.lockFactory = context.createConfiguredLockFactory().orElseGet(SingleInstanceLockFactory::new);
    }

    @Override
    public DirectoryHolder createDirectory(DirectoryCreationContext context) throws IOException {
        ByteBuffersDirectory directory = new ByteBuffersDirectory(this.lockFactory);
        try {
            context.initializeIndexIfNeeded((Directory)directory);
            return DirectoryHolder.of((Directory)directory);
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)directory);
            throw e;
        }
    }
}

