/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.index.impl;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegatorImpl;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.common.impl.Closer;

public class IndexAccessor
implements AutoCloseable {
    private final DirectoryHolder directoryHolder;
    private final IndexWriterDelegatorImpl indexWriterDelegator;

    public IndexAccessor(String indexName, DirectoryHolder directoryHolder, Analyzer analyzer, ErrorHandler errorHandler) {
        this.directoryHolder = directoryHolder;
        this.indexWriterDelegator = new IndexWriterDelegatorImpl(indexName, directoryHolder.get(), analyzer, errorHandler);
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(IndexWriterDelegatorImpl::close, (Object)this.indexWriterDelegator);
            closer.push(DirectoryHolder::close, (Object)this.directoryHolder);
        }
    }

    public IndexWriterDelegator getIndexWriterDelegator() {
        return this.indexWriterDelegator;
    }

    public DirectoryReader openNRTIndexReader(boolean applyDeletes) throws IOException {
        IndexWriter indexWriter = this.indexWriterDelegator.getIndexWriterOrNull();
        if (indexWriter != null) {
            return DirectoryReader.open((IndexWriter)indexWriter, (boolean)applyDeletes, (boolean)applyDeletes);
        }
        return null;
    }

    public DirectoryReader openDirectoryIndexReader() throws IOException {
        return DirectoryReader.open((Directory)this.directoryHolder.get());
    }

    public Directory getDirectoryForTests() {
        return this.directoryHolder.get();
    }
}

