/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.impl;

import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;

public class LuceneIndexScope
implements IndexScope<LuceneSearchQueryElementCollector> {
    private final LuceneScopeModel model;
    private final LuceneSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final LuceneSearchSortBuilderFactoryImpl searchSortFactory;
    private final LuceneSearchQueryBuilderFactory searchQueryFactory;
    private final LuceneSearchProjectionBuilderFactory searchProjectionFactory;

    public LuceneIndexScope(SearchBackendContext searchBackendContext, MappingContextImplementor mappingContext, LuceneScopeModel model) {
        LuceneSearchContext searchContext = searchBackendContext.createSearchContext(mappingContext, model);
        this.model = model;
        this.searchPredicateFactory = new LuceneSearchPredicateBuilderFactoryImpl(searchContext, model);
        this.searchSortFactory = new LuceneSearchSortBuilderFactoryImpl(searchContext, model);
        this.searchProjectionFactory = new LuceneSearchProjectionBuilderFactory(model);
        this.searchQueryFactory = new LuceneSearchQueryBuilderFactory(searchBackendContext, searchContext, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.model.getIndexNames() + "]";
    }

    public LuceneSearchPredicateBuilderFactoryImpl getSearchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public LuceneSearchSortBuilderFactoryImpl getSearchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public LuceneSearchQueryBuilderFactory getSearchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public LuceneSearchProjectionBuilderFactory getSearchProjectionFactory() {
        return this.searchProjectionFactory;
    }
}

