/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.dsl.query.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.scope.impl.LuceneIndexScope;
import org.hibernate.search.backend.lucene.search.dsl.predicate.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.dsl.projection.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.dsl.query.LuceneSearchQueryHitTypeStep;
import org.hibernate.search.backend.lucene.search.dsl.query.LuceneSearchQueryOptionsStep;
import org.hibernate.search.backend.lucene.search.dsl.query.LuceneSearchQueryPredicateStep;
import org.hibernate.search.backend.lucene.search.dsl.query.impl.LuceneSearchQueryOptionsStepImpl;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.predicate.PredicateFinalStep;
import org.hibernate.search.engine.search.dsl.projection.ProjectionFinalStep;
import org.hibernate.search.engine.search.dsl.query.spi.AbstractSearchQueryHitTypeStep;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class LuceneSearchQueryHitTypeStepImpl<R, E>
extends AbstractSearchQueryHitTypeStep<LuceneSearchQueryOptionsStep<E>, R, E, LuceneSearchProjectionFactory<R, E>, LuceneSearchPredicateFactory, LuceneSearchQueryElementCollector>
implements LuceneSearchQueryHitTypeStep<R, E> {
    private final LuceneIndexScope indexScope;
    private final SessionContextImplementor sessionContext;
    private final LoadingContextBuilder<R, E> loadingContextBuilder;

    public LuceneSearchQueryHitTypeStepImpl(LuceneIndexScope indexScope, SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public LuceneSearchQueryPredicateStep<E> asEntity() {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asEntity(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryPredicateStep<R> asEntityReference() {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asReference(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public <P> LuceneSearchQueryPredicateStep<P> asProjection(Function<? super LuceneSearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        LuceneSearchProjectionFactory factoryContext = (LuceneSearchProjectionFactory)this.createDefaultProjectionFactory().extension(LuceneExtension.get());
        SearchProjection projection = projectionContributor.apply(factoryContext).toProjection();
        return this.asProjection(projection);
    }

    @Override
    public <P> LuceneSearchQueryPredicateStep<P> asProjection(SearchProjection<P> projection) {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asProjection(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection)projection);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryPredicateStep<List<?>> asProjections(SearchProjection<?> ... projections) {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asProjections(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection[])projections);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    public LuceneSearchQueryOptionsStep<E> predicate(SearchPredicate predicate) {
        return (LuceneSearchQueryOptionsStep)this.asEntity().predicate(predicate);
    }

    public LuceneSearchQueryOptionsStep<E> predicate(Function<? super LuceneSearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return (LuceneSearchQueryOptionsStep)this.asEntity().predicate(predicateContributor);
    }

    protected LuceneIndexScope getIndexScope() {
        return this.indexScope;
    }

    protected SessionContextImplementor getSessionContext() {
        return this.sessionContext;
    }

    protected LoadingContextBuilder<R, E> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }

    private <H> LuceneSearchQueryPredicateStep<H> createSearchQueryContext(LuceneSearchQueryBuilder<H> builder) {
        return new LuceneSearchQueryOptionsStepImpl<H>(this.indexScope, builder);
    }
}

