/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneStandardRangePredicateBuilder<F, E, C extends LuceneStandardFieldCodec<F, E>>
extends AbstractLuceneSearchPredicateBuilder
implements RangePredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchContext searchContext;
    protected final String absoluteFieldPath;
    private final ToDocumentFieldValueConverter<?, ? extends F> converter;
    private final ToDocumentFieldValueConverter<F, ? extends F> rawConverter;
    private final LuceneCompatibilityChecker converterChecker;
    protected final C codec;
    protected E lowerLimit;
    protected boolean excludeLowerLimit = false;
    protected E upperLimit;
    protected boolean excludeUpperLimit = false;

    protected AbstractLuceneStandardRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, C codec) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.converterChecker = converterChecker;
        this.codec = codec;
    }

    public void lowerLimit(Object value, DslConverter dslConverter) {
        ToDocumentFieldValueConverter<?, F> dslToIndexConverter = this.getDslToIndexConverter(dslConverter);
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.lowerLimit = this.codec.encode((Object)converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    public void excludeLowerLimit() {
        this.excludeLowerLimit = true;
    }

    public void upperLimit(Object value, DslConverter dslConverter) {
        ToDocumentFieldValueConverter<?, F> dslToIndexConverter = this.getDslToIndexConverter(dslConverter);
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.upperLimit = this.codec.encode((Object)converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    public void excludeUpperLimit() {
        this.excludeUpperLimit = true;
    }

    public ToDocumentFieldValueConverter<?, ? extends F> getDslToIndexConverter(DslConverter dslConverter) {
        if (dslConverter.isEnabled()) {
            this.converterChecker.failIfNotCompatible();
        }
        return dslConverter.isEnabled() ? this.converter : this.rawConverter;
    }
}

