/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopedIndexFieldComponent;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneSucceedingCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.backend.lucene.util.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.util.impl.FieldContextSimpleQueryParser;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSimpleQueryStringPredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements SimpleQueryStringPredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneScopeModel scopeModel;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final Map<String, LuceneSimpleQueryStringPredicateBuilderFieldState> fields = new LinkedHashMap<String, LuceneSimpleQueryStringPredicateBuilderFieldState>();
    private BooleanClause.Occur defaultOperator = BooleanClause.Occur.SHOULD;
    private String simpleQueryString;
    private Analyzer overrideAnalyzer;
    private boolean ignoreAnalyzer = false;
    private LuceneCompatibilityChecker analyzerChecker = new LuceneSucceedingCompatibilityChecker();

    LuceneSimpleQueryStringPredicateBuilder(LuceneSearchContext searchContext, LuceneScopeModel scopeModel) {
        this.scopeModel = scopeModel;
        this.analysisDefinitionRegistry = searchContext.getAnalysisDefinitionRegistry();
    }

    public void withAndAsDefaultOperator() {
        this.defaultOperator = BooleanClause.Occur.MUST;
    }

    public SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
        LuceneSimpleQueryStringPredicateBuilderFieldState field = this.fields.get(absoluteFieldPath);
        if (field == null) {
            LuceneScopedIndexFieldComponent<LuceneFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, LuceneSearchPredicateBuilderFactoryImpl.PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
            field = fieldComponent.getComponent().createSimpleQueryStringFieldContext(absoluteFieldPath);
            this.analyzerChecker = this.analyzerChecker.combine(fieldComponent.getAnalyzerCompatibilityChecker());
            this.fields.put(absoluteFieldPath, field);
        }
        return field;
    }

    public void simpleQueryString(String simpleQueryString) {
        this.simpleQueryString = simpleQueryString;
    }

    public void analyzer(String analyzerName) {
        this.overrideAnalyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
        if (this.overrideAnalyzer == null) {
            throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexNames(this.scopeModel.getIndexNames()));
        }
    }

    public void skipAnalysis() {
        this.ignoreAnalyzer = true;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        if (!this.ignoreAnalyzer && this.overrideAnalyzer == null) {
            this.analyzerChecker.failIfNotCompatible();
        }
        Analyzer analyzer = this.buildAnalyzer();
        FieldContextSimpleQueryParser queryParser = new FieldContextSimpleQueryParser(analyzer, this.fields);
        queryParser.setDefaultOperator(this.defaultOperator);
        return queryParser.parse(this.simpleQueryString);
    }

    private Analyzer buildAnalyzer() {
        if (this.ignoreAnalyzer) {
            return AnalyzerConstants.KEYWORD_ANALYZER;
        }
        if (this.overrideAnalyzer != null) {
            return this.overrideAnalyzer;
        }
        if (this.fields.size() == 1) {
            return this.fields.values().iterator().next().getAnalyzer();
        }
        ScopedAnalyzer.Builder builder = new ScopedAnalyzer.Builder();
        for (Map.Entry<String, LuceneSimpleQueryStringPredicateBuilderFieldState> entry : this.fields.entrySet()) {
            builder.setAnalyzer(entry.getKey(), entry.getValue().getAnalyzer());
        }
        return builder.build();
    }
}

