/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Set;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class LuceneCompositeFunctionProjection<E, P1, P>
implements LuceneCompositeProjection<E, P> {
    private final Set<String> indexNames;
    private final Function<P1, P> transformer;
    private final LuceneSearchProjection<E, P1> projection;

    public LuceneCompositeFunctionProjection(Set<String> indexNames, Function<P1, P> transformer, LuceneSearchProjection<E, P1> projection) {
        this.indexNames = indexNames;
        this.transformer = transformer;
        this.projection = projection;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        this.projection.contributeCollectors(luceneCollectorBuilder);
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        this.projection.contributeFields(builder);
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> projectionHitMapper, LuceneResult luceneResult, SearchProjectionExtractContext context) {
        return this.projection.extract(projectionHitMapper, luceneResult, context);
    }

    @Override
    public P transform(LoadingResult<?> loadingResult, E extractedData, SearchProjectionTransformContext context) {
        return this.transformer.apply(this.projection.transform(loadingResult, extractedData, context));
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection=").append(this.projection).append("]");
        return sb.toString();
    }
}

