/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class LuceneFieldProjection<F, V>
implements LuceneSearchProjection<F, V> {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final LuceneFieldCodec<F> codec;
    private final FromDocumentFieldValueConverter<? super F, V> converter;

    LuceneFieldProjection(Set<String> indexNames, String absoluteFieldPath, LuceneFieldCodec<F> codec, FromDocumentFieldValueConverter<? super F, V> converter) {
        this.indexNames = indexNames;
        this.absoluteFieldPath = absoluteFieldPath;
        this.codec = codec;
        this.converter = converter;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        luceneCollectorBuilder.requireTopDocsCollector();
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        this.codec.contributeStoredFields(this.absoluteFieldPath, builder::add);
    }

    @Override
    public F extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return this.codec.decode(documentResult.getDocument(), this.absoluteFieldPath);
    }

    @Override
    public V transform(LoadingResult<?> loadingResult, F extractedData, SearchProjectionTransformContext context) {
        FromDocumentFieldValueConvertContext convertContext = context.getFromDocumentFieldValueConvertContext();
        return (V)this.converter.convert(extractedData, convertContext);
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append("]");
        return sb.toString();
    }
}

