/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultImpl;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class LuceneLoadableSearchResult<H> {
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final long hitCount;
    private List<Object> extractedData;

    LuceneLoadableSearchResult(ProjectionHitMapper<?, ?> projectionHitMapper, LuceneSearchProjection<?, H> rootProjection, long hitCount, List<Object> extractedData) {
        this.projectionHitMapper = projectionHitMapper;
        this.rootProjection = rootProjection;
        this.hitCount = hitCount;
        this.extractedData = extractedData;
    }

    long getHitCount() {
        return this.hitCount;
    }

    LuceneSearchResult<H> loadBlocking(SessionContextImplementor sessionContext) {
        int readIndex;
        SearchProjectionTransformContext transformContext = new SearchProjectionTransformContext(sessionContext);
        LoadingResult loadingResult = this.projectionHitMapper.loadBlocking();
        int writeIndex = 0;
        for (readIndex = 0; readIndex < this.extractedData.size(); ++readIndex) {
            transformContext.reset();
            H transformed = LuceneSearchProjection.transformUnsafe(this.rootProjection, loadingResult, this.extractedData.get(readIndex), transformContext);
            if (transformContext.hasFailedLoad()) continue;
            this.extractedData.set(writeIndex, transformed);
            ++writeIndex;
        }
        if (writeIndex < readIndex) {
            this.extractedData.subList(writeIndex, readIndex).clear();
        }
        List<Object> loadedHits = Collections.unmodifiableList(this.extractedData);
        this.extractedData = null;
        return new LuceneSearchResultImpl<Object>(this.hitCount, loadedHits);
    }
}

