/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.backend.lucene.search.impl.LuceneQueries;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractorImpl;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class LuceneSearchQueryBuilder<H>
implements SearchQueryBuilder<H, LuceneSearchQueryElementCollector> {
    private final LuceneWorkFactory workFactory;
    private final LuceneReadWorkOrchestrator queryOrchestrator;
    private final LuceneSearchContext searchContext;
    private final SessionContextImplementor sessionContext;
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private final LoadingContextBuilder<?, ?> loadingContextBuilder;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final LuceneSearchQueryElementCollector elementCollector;

    LuceneSearchQueryBuilder(LuceneWorkFactory workFactory, LuceneReadWorkOrchestrator queryOrchestrator, LuceneSearchContext searchContext, SessionContextImplementor sessionContext, ReusableDocumentStoredFieldVisitor storedFieldVisitor, LoadingContextBuilder<?, ?> loadingContextBuilder, LuceneSearchProjection<?, H> rootProjection) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.elementCollector = new LuceneSearchQueryElementCollector();
        this.storedFieldVisitor = storedFieldVisitor;
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
    }

    public LuceneSearchQueryElementCollector getQueryElementCollector() {
        return this.elementCollector;
    }

    public void addRoutingKey(String routingKey) {
        throw new UnsupportedOperationException("Routing keys are not supported by the Lucene backend yet.");
    }

    public LuceneSearchQuery<H> build() {
        LoadingContext loadingContext = this.loadingContextBuilder.build();
        LuceneSearchResultExtractorImpl<H> searchResultExtractor = new LuceneSearchResultExtractorImpl<H>(this.storedFieldVisitor, this.rootProjection, loadingContext);
        BooleanQuery.Builder luceneQueryBuilder = new BooleanQuery.Builder();
        luceneQueryBuilder.add(this.elementCollector.toLuceneQueryPredicate(), BooleanClause.Occur.MUST);
        luceneQueryBuilder.add(LuceneQueries.mainDocumentQuery(), BooleanClause.Occur.FILTER);
        return new LuceneSearchQueryImpl<H>(this.queryOrchestrator, this.workFactory, this.searchContext, this.sessionContext, loadingContext, this.searchContext.decorateLuceneQuery((Query)luceneQueryBuilder.build(), this.sessionContext.getTenantIdentifier()), this.elementCollector.toLuceneSort(), this.rootProjection, searchResultExtractor);
    }
}

