/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorProvider;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractor;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.spi.AbstractSearchQuery;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchQueryImpl<H>
extends AbstractSearchQuery<H, LuceneSearchResult<H>>
implements LuceneSearchQuery<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneReadWorkOrchestrator queryOrchestrator;
    private final LuceneWorkFactory workFactory;
    private final LuceneSearchContext searchContext;
    private final SessionContextImplementor sessionContext;
    private final LoadingContext<?, ?> loadingContext;
    private final Query luceneQuery;
    private final Sort luceneSort;
    private final LuceneCollectorProvider luceneCollectorProvider;
    private final LuceneSearchResultExtractor<H> searchResultExtractor;

    LuceneSearchQueryImpl(LuceneReadWorkOrchestrator queryOrchestrator, LuceneWorkFactory workFactory, LuceneSearchContext searchContext, SessionContextImplementor sessionContext, LoadingContext<?, ?> loadingContext, Query luceneQuery, Sort luceneSort, LuceneCollectorProvider luceneCollectorProvider, LuceneSearchResultExtractor<H> searchResultExtractor) {
        this.queryOrchestrator = queryOrchestrator;
        this.workFactory = workFactory;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.luceneQuery = luceneQuery;
        this.luceneSort = luceneSort;
        this.luceneCollectorProvider = luceneCollectorProvider;
        this.searchResultExtractor = searchResultExtractor;
    }

    public String getQueryString() {
        return this.luceneQuery.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[query=" + this.getQueryString() + ", sort=" + this.luceneSort + "]";
    }

    public <Q> Q extension(SearchQueryExtension<Q, H> extension) {
        return (Q)DslExtensionState.returnIfSupported(extension, (Optional)extension.extendOptional((SearchQuery)this, this.loadingContext));
    }

    public LuceneSearchResult<H> fetch(Integer limit, Integer offset) {
        LuceneReadWork<LuceneLoadableSearchResult<H>> work = this.workFactory.search(this.searchContext.getIndexNames(), this.luceneQuery, this.luceneSort, offset, limit, this.luceneCollectorProvider, this.searchResultExtractor);
        return this.queryOrchestrator.submit(this.searchContext.getIndexNames(), this.searchContext.getReaderProviders(), work).loadBlocking(this.sessionContext);
    }

    public long fetchTotalHitCount() {
        LuceneReadWork<LuceneLoadableSearchResult<H>> work = this.workFactory.search(this.searchContext.getIndexNames(), this.luceneQuery, this.luceneSort, 0, 0, luceneCollectorBuilder -> {}, this.searchResultExtractor);
        return this.queryOrchestrator.submit(this.searchContext.getIndexNames(), this.searchContext.getReaderProviders(), work).getHitCount();
    }

    @Override
    public Explanation explain(String id) {
        Contracts.assertNotNull((Object)id, (String)"id");
        Set<String> targetedIndexNames = this.searchContext.getIndexNames();
        if (targetedIndexNames.size() != 1) {
            throw log.explainRequiresIndexName(targetedIndexNames);
        }
        return this.doExplain(targetedIndexNames.iterator().next(), id);
    }

    @Override
    public Explanation explain(String indexName, String id) {
        Contracts.assertNotNull((Object)indexName, (String)"indexName");
        Contracts.assertNotNull((Object)id, (String)"id");
        Set<String> targetedIndexNames = this.searchContext.getIndexNames();
        if (!targetedIndexNames.contains(indexName)) {
            throw log.explainRequiresIndexTargetedByQuery(targetedIndexNames, indexName);
        }
        return this.doExplain(indexName, id);
    }

    private Explanation doExplain(String indexName, String id) {
        BooleanQuery explainedDocumentQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(LuceneFields.indexFieldName(), indexName)), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term(LuceneFields.idFieldName(), id)), BooleanClause.Occur.MUST).build();
        explainedDocumentQuery = this.searchContext.decorateLuceneQuery((Query)explainedDocumentQuery, this.sessionContext.getTenantIdentifier());
        LuceneReadWork<Explanation> work = this.workFactory.explain(this.searchContext.getIndexNames(), this.luceneQuery, indexName, id, (Query)explainedDocumentQuery);
        return this.queryOrchestrator.submit(this.searchContext.getIndexNames(), this.searchContext.getReaderProviders(), work);
    }
}

