/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class LuceneSearchResultExtractorImpl<H>
implements LuceneSearchResultExtractor<H> {
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final LoadingContext<?, ?> loadingContext;

    LuceneSearchResultExtractorImpl(ReusableDocumentStoredFieldVisitor storedFieldVisitor, LuceneSearchProjection<?, H> rootProjection, LoadingContext<?, ?> loadingContext) {
        this.storedFieldVisitor = storedFieldVisitor;
        this.rootProjection = rootProjection;
        this.loadingContext = loadingContext;
    }

    @Override
    public LuceneLoadableSearchResult<H> extract(IndexSearcher indexSearcher, long totalHits, TopDocs topDocs, SearchProjectionExtractContext projectionExecutionContext) throws IOException {
        ProjectionHitMapper projectionHitMapper = this.loadingContext.getProjectionHitMapper();
        List<Object> extractedData = this.extractHits(projectionHitMapper, indexSearcher, topDocs, projectionExecutionContext);
        return new LuceneLoadableSearchResult<H>(projectionHitMapper, this.rootProjection, totalHits, extractedData);
    }

    private List<Object> extractHits(ProjectionHitMapper<?, ?> projectionHitMapper, IndexSearcher indexSearcher, TopDocs topDocs, SearchProjectionExtractContext projectionExecutionContext) throws IOException {
        if (topDocs == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> extractedData = new ArrayList<Object>(topDocs.scoreDocs.length);
        for (ScoreDoc hit : topDocs.scoreDocs) {
            indexSearcher.doc(hit.doc, (StoredFieldVisitor)this.storedFieldVisitor);
            Document document = this.storedFieldVisitor.getDocumentAndReset();
            LuceneResult luceneResult = new LuceneResult(document, hit.doc, hit.score);
            extractedData.add(this.rootProjection.extract(projectionHitMapper, luceneResult, projectionExecutionContext));
        }
        return extractedData;
    }
}

