/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;

public final class LuceneBooleanFieldCodec
extends AbstractLuceneNumericFieldCodec<Boolean, Integer> {
    public LuceneBooleanFieldCodec(boolean projectable, boolean searchable, boolean sortable, Boolean indexNullAsValue) {
        super(projectable, searchable, sortable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Boolean value, Integer encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.intValue()));
    }

    @Override
    public Boolean decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        Integer intValue = (Integer)field.numericValue();
        return intValue > 0;
    }

    @Override
    public Integer encode(Boolean value) {
        return value != false ? 1 : 0;
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneNumericDomain.INTEGER;
    }
}

