/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;

public final class LuceneDoubleFieldCodec
extends AbstractLuceneNumericFieldCodec<Double, Double> {
    public LuceneDoubleFieldCodec(boolean projectable, boolean searchable, boolean sortable, Double indexNullAsValue) {
        super(projectable, searchable, sortable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Double value, Double encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.doubleValue()));
    }

    @Override
    public Double decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return (Double)field.numericValue();
    }

    @Override
    public Double encode(Double value) {
        return value;
    }

    @Override
    public LuceneNumericDomain<Double> getDomain() {
        return LuceneNumericDomain.DOUBLE;
    }
}

