/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneYearMonthFieldCodec;

public final class LuceneLocalDateFieldCodec
extends AbstractLuceneNumericFieldCodec<LocalDate, Long> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(LuceneYearMonthFieldCodec.FORMATTER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);

    public LuceneLocalDateFieldCodec(boolean projectable, boolean searchable, boolean sortable, LocalDate indexNullAsValue) {
        super(projectable, searchable, sortable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, LocalDate value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public LocalDate decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return LocalDate.parse(value, FORMATTER);
    }

    @Override
    public Long encode(LocalDate value) {
        return value == null ? null : Long.valueOf(value.toEpochDay());
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }
}

