/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;

public final class LuceneLongFieldCodec
extends AbstractLuceneNumericFieldCodec<Long, Long> {
    public LuceneLongFieldCodec(boolean projectable, boolean searchable, boolean sortable, Long indexNullAsValue) {
        super(projectable, searchable, sortable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Long value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.longValue()));
    }

    @Override
    public Long decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return (Long)field.numericValue();
    }

    @Override
    public Long encode(Long value) {
        return value;
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }
}

