/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneBigDecimalFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneBigDecimalIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneBigDecimalIndexFieldTypeOptionsStep, BigDecimal>
implements ScaledNumberIndexFieldTypeOptionsStep<LuceneBigDecimalIndexFieldTypeOptionsStep, BigDecimal> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Sortable sortable = Sortable.DEFAULT;
    private Integer decimalScale = null;

    LuceneBigDecimalIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigDecimal.class);
        this.defaultsProvider = defaultsProvider;
    }

    public LuceneBigDecimalIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    public LuceneBigDecimalIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this;
    }

    @Override
    public LuceneIndexFieldType<BigDecimal> toIndexFieldType() {
        boolean resolvedSortable = LuceneBigDecimalIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneBigDecimalIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneBigDecimalIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneBigDecimalFieldCodec codec = new LuceneBigDecimalFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (BigDecimal)this.indexNullAsValue, this.resolveDecimalScale());
        return new LuceneIndexFieldType<BigDecimal>(codec, new LuceneNumericFieldPredicateBuilderFactory<BigDecimal, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, BigDecimal>)dslToIndexConverter, (ToDocumentFieldValueConverter<BigDecimal, BigDecimal>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<BigDecimal, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, BigDecimal>)dslToIndexConverter, (ToDocumentFieldValueConverter<BigDecimal, BigDecimal>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<BigDecimal>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneBigDecimalIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.getDecimalScale() != null) {
            return this.defaultsProvider.getDecimalScale();
        }
        throw log.nullDecimalScale(this.getBuildContext().getEventContext());
    }
}

