/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneBooleanFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneBooleanIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneBooleanIndexFieldTypeOptionsStep, Boolean> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneBooleanIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Boolean.class);
    }

    public LuceneBooleanIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Boolean> toIndexFieldType() {
        boolean resolvedSortable = LuceneBooleanIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneBooleanIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneBooleanIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneBooleanFieldCodec codec = new LuceneBooleanFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Boolean)this.indexNullAsValue);
        return new LuceneIndexFieldType<Boolean>(codec, new LuceneNumericFieldPredicateBuilderFactory<Boolean, Integer>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Boolean>)dslToIndexConverter, (ToDocumentFieldValueConverter<Boolean, Boolean>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Boolean, Integer>(resolvedSortable, (ToDocumentFieldValueConverter<?, Boolean>)dslToIndexConverter, (ToDocumentFieldValueConverter<Boolean, Boolean>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Boolean>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneBooleanIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

