/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDoubleFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneDoubleIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneDoubleIndexFieldTypeOptionsStep, Double> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneDoubleIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Double.class);
    }

    public LuceneDoubleIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Double> toIndexFieldType() {
        boolean resolvedSortable = LuceneDoubleIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneDoubleIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneDoubleIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneDoubleFieldCodec codec = new LuceneDoubleFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Double)this.indexNullAsValue);
        return new LuceneIndexFieldType<Double>(codec, new LuceneNumericFieldPredicateBuilderFactory<Double, Double>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Double>)dslToIndexConverter, (ToDocumentFieldValueConverter<Double, Double>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Double, Double>(resolvedSortable, (ToDocumentFieldValueConverter<?, Double>)dslToIndexConverter, (ToDocumentFieldValueConverter<Double, Double>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Double>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneDoubleIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

