/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFloatFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneFloatIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneFloatIndexFieldTypeOptionsStep, Float> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneFloatIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Float.class);
    }

    public LuceneFloatIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Float> toIndexFieldType() {
        boolean resolvedSortable = LuceneFloatIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneFloatIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneFloatIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneFloatFieldCodec codec = new LuceneFloatFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Float)this.indexNullAsValue);
        return new LuceneIndexFieldType<Float>(codec, new LuceneNumericFieldPredicateBuilderFactory<Float, Float>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Float>)dslToIndexConverter, (ToDocumentFieldValueConverter<Float, Float>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Float, Float>(resolvedSortable, (ToDocumentFieldValueConverter<?, Float>)dslToIndexConverter, (ToDocumentFieldValueConverter<Float, Float>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Float>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneFloatIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

