/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.Instant;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneInstantFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneInstantIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneInstantIndexFieldTypeOptionsStep, Instant> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneInstantIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Instant.class);
    }

    public LuceneInstantIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Instant> toIndexFieldType() {
        boolean resolvedSortable = LuceneInstantIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneInstantIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneInstantIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneInstantFieldCodec codec = new LuceneInstantFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Instant)this.indexNullAsValue);
        return new LuceneIndexFieldType<Instant>(codec, new LuceneNumericFieldPredicateBuilderFactory<Instant, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Instant>)dslToIndexConverter, (ToDocumentFieldValueConverter<Instant, Instant>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Instant, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, Instant>)dslToIndexConverter, (ToDocumentFieldValueConverter<Instant, Instant>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Instant>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneInstantIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

