/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneIntegerFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneIntegerIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneIntegerIndexFieldTypeOptionsStep, Integer> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneIntegerIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Integer.class);
    }

    public LuceneIntegerIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Integer> toIndexFieldType() {
        boolean resolvedSortable = LuceneIntegerIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneIntegerIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneIntegerIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneIntegerFieldCodec codec = new LuceneIntegerFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Integer)this.indexNullAsValue);
        return new LuceneIndexFieldType<Integer>(codec, new LuceneNumericFieldPredicateBuilderFactory<Integer, Integer>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Integer>)dslToIndexConverter, (ToDocumentFieldValueConverter<Integer, Integer>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Integer, Integer>(resolvedSortable, (ToDocumentFieldValueConverter<?, Integer>)dslToIndexConverter, (ToDocumentFieldValueConverter<Integer, Integer>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Integer>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneIntegerIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

