/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.LocalDate;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalDateFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneLocalDateIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneLocalDateIndexFieldTypeOptionsStep, LocalDate> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneLocalDateIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, LocalDate.class);
    }

    public LuceneLocalDateIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<LocalDate> toIndexFieldType() {
        boolean resolvedSortable = LuceneLocalDateIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneLocalDateIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneLocalDateIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneLocalDateFieldCodec codec = new LuceneLocalDateFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (LocalDate)this.indexNullAsValue);
        return new LuceneIndexFieldType<LocalDate>(codec, new LuceneNumericFieldPredicateBuilderFactory<LocalDate, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, LocalDate>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDate, LocalDate>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<LocalDate, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, LocalDate>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDate, LocalDate>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<LocalDate>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneLocalDateIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

