/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.LocalDateTime;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalDateTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneLocalDateTimeIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneLocalDateTimeIndexFieldTypeOptionsStep, LocalDateTime> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneLocalDateTimeIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, LocalDateTime.class);
    }

    public LuceneLocalDateTimeIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<LocalDateTime> toIndexFieldType() {
        boolean resolvedSortable = LuceneLocalDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneLocalDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneLocalDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneLocalDateTimeFieldCodec codec = new LuceneLocalDateTimeFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (LocalDateTime)this.indexNullAsValue);
        return new LuceneIndexFieldType<LocalDateTime>(codec, new LuceneNumericFieldPredicateBuilderFactory<LocalDateTime, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, LocalDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDateTime, LocalDateTime>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<LocalDateTime, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, LocalDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDateTime, LocalDateTime>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<LocalDateTime>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneLocalDateTimeIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

