/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLongFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneLongIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneLongIndexFieldTypeOptionsStep, Long> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneLongIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Long.class);
    }

    public LuceneLongIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Long> toIndexFieldType() {
        boolean resolvedSortable = LuceneLongIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneLongIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneLongIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneLongFieldCodec codec = new LuceneLongFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Long)this.indexNullAsValue);
        return new LuceneIndexFieldType<Long>(codec, new LuceneNumericFieldPredicateBuilderFactory<Long, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Long>)dslToIndexConverter, (ToDocumentFieldValueConverter<Long, Long>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Long, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, Long>)dslToIndexConverter, (ToDocumentFieldValueConverter<Long, Long>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Long>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneLongIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

