/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.OffsetDateTime;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneOffsetDateTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneOffsetDateTimeIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneOffsetDateTimeIndexFieldTypeOptionsStep, OffsetDateTime> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneOffsetDateTimeIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, OffsetDateTime.class);
    }

    public LuceneOffsetDateTimeIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<OffsetDateTime> toIndexFieldType() {
        boolean resolvedSortable = LuceneOffsetDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneOffsetDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneOffsetDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneOffsetDateTimeFieldCodec codec = new LuceneOffsetDateTimeFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (OffsetDateTime)this.indexNullAsValue);
        return new LuceneIndexFieldType<OffsetDateTime>(codec, new LuceneNumericFieldPredicateBuilderFactory<OffsetDateTime, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, OffsetDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<OffsetDateTime, OffsetDateTime>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<OffsetDateTime, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, OffsetDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<OffsetDateTime, OffsetDateTime>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<OffsetDateTime>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneOffsetDateTimeIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

