/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.OffsetTime;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneOffsetTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneOffsetTimeIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneOffsetTimeIndexFieldTypeOptionsStep, OffsetTime> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneOffsetTimeIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, OffsetTime.class);
    }

    public LuceneOffsetTimeIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<OffsetTime> toIndexFieldType() {
        boolean resolvedSortable = LuceneOffsetTimeIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneOffsetTimeIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneOffsetTimeIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneOffsetTimeFieldCodec codec = new LuceneOffsetTimeFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (OffsetTime)this.indexNullAsValue);
        return new LuceneIndexFieldType<OffsetTime>(codec, new LuceneNumericFieldPredicateBuilderFactory<OffsetTime, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, OffsetTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<OffsetTime, OffsetTime>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<OffsetTime, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, OffsetTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<OffsetTime, OffsetTime>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<OffsetTime>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneOffsetTimeIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

