/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneShortFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneShortIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneShortIndexFieldTypeOptionsStep, Short> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneShortIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Short.class);
    }

    public LuceneShortIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Short> toIndexFieldType() {
        boolean resolvedSortable = LuceneShortIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneShortIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneShortIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneShortFieldCodec codec = new LuceneShortFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Short)this.indexNullAsValue);
        return new LuceneIndexFieldType<Short>(codec, new LuceneNumericFieldPredicateBuilderFactory<Short, Integer>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Short>)dslToIndexConverter, (ToDocumentFieldValueConverter<Short, Short>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Short, Integer>(resolvedSortable, (ToDocumentFieldValueConverter<?, Short>)dslToIndexConverter, (ToDocumentFieldValueConverter<Short, Short>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Short>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneShortIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

