/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.Year;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneYearFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneYearIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneYearIndexFieldTypeOptionsStep, Year> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneYearIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Year.class);
    }

    public LuceneYearIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Year> toIndexFieldType() {
        boolean resolvedSortable = LuceneYearIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneYearIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneYearIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneYearFieldCodec codec = new LuceneYearFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (Year)this.indexNullAsValue);
        return new LuceneIndexFieldType<Year>(codec, new LuceneNumericFieldPredicateBuilderFactory<Year, Integer>(resolvedSearchable, (ToDocumentFieldValueConverter<?, Year>)dslToIndexConverter, (ToDocumentFieldValueConverter<Year, Year>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Year, Integer>(resolvedSortable, (ToDocumentFieldValueConverter<?, Year>)dslToIndexConverter, (ToDocumentFieldValueConverter<Year, Year>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Year>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneYearIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

