/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.YearMonth;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneYearMonthFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneYearMonthIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneYearMonthIndexFieldTypeOptionsStep, YearMonth> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneYearMonthIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, YearMonth.class);
    }

    public LuceneYearMonthIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<YearMonth> toIndexFieldType() {
        boolean resolvedSortable = LuceneYearMonthIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneYearMonthIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneYearMonthIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneYearMonthFieldCodec codec = new LuceneYearMonthFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (YearMonth)this.indexNullAsValue);
        return new LuceneIndexFieldType<YearMonth>(codec, new LuceneNumericFieldPredicateBuilderFactory<YearMonth, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, YearMonth>)dslToIndexConverter, (ToDocumentFieldValueConverter<YearMonth, YearMonth>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<YearMonth, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, YearMonth>)dslToIndexConverter, (ToDocumentFieldValueConverter<YearMonth, YearMonth>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<YearMonth>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneYearMonthIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

