/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.ZonedDateTime;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneZonedDateTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneZonedDateTimeIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneZonedDateTimeIndexFieldTypeOptionsStep, ZonedDateTime> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneZonedDateTimeIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, ZonedDateTime.class);
    }

    public LuceneZonedDateTimeIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<ZonedDateTime> toIndexFieldType() {
        boolean resolvedSortable = LuceneZonedDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneZonedDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneZonedDateTimeIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneZonedDateTimeFieldCodec codec = new LuceneZonedDateTimeFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, (ZonedDateTime)this.indexNullAsValue);
        return new LuceneIndexFieldType<ZonedDateTime>(codec, new LuceneNumericFieldPredicateBuilderFactory<ZonedDateTime, Long>(resolvedSearchable, (ToDocumentFieldValueConverter<?, ZonedDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<ZonedDateTime, ZonedDateTime>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<ZonedDateTime, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, ZonedDateTime>)dslToIndexConverter, (ToDocumentFieldValueConverter<ZonedDateTime, ZonedDateTime>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<ZonedDateTime>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneZonedDateTimeIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

