/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneStandardRangePredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneNumericRangePredicateBuilder<F, E extends Number>
extends AbstractLuceneStandardRangePredicateBuilder<F, E, AbstractLuceneNumericFieldCodec<F, E>> {
    LuceneNumericRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, AbstractLuceneNumericFieldCodec<F, E> codec) {
        super(searchContext, absoluteFieldPath, converter, rawConverter, converterChecker, codec);
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        LuceneNumericDomain<Object> domain = ((AbstractLuceneNumericFieldCodec)this.codec).getDomain();
        return domain.createRangeQuery(this.absoluteFieldPath, LuceneNumericRangePredicateBuilder.getLowerValue(domain, this.lowerLimit, this.excludeLowerLimit), LuceneNumericRangePredicateBuilder.getUpperValue(domain, this.upperLimit, this.excludeUpperLimit));
    }

    private static <E> E getLowerValue(LuceneNumericDomain<E> domain, E lowerLimit, boolean excludeLowerLimit) {
        if (lowerLimit == null) {
            return domain.getMinValue();
        }
        return excludeLowerLimit ? domain.getNextValue(lowerLimit) : lowerLimit;
    }

    private static <E> E getUpperValue(LuceneNumericDomain<E> domain, E upperLimit, boolean excludeUpperLimit) {
        if (upperLimit == null) {
            return domain.getMaxValue();
        }
        return excludeUpperLimit ? domain.getPreviousValue(upperLimit) : upperLimit;
    }
}

